---
title: Respond with another site · Cloudflare Workers docs
description: Respond to the Worker request with the response from another
  website (example.com in this example).
lastUpdated: 2025-10-17T07:10:47.000Z
chatbotDeprioritize: false
tags: Middleware,JavaScript,TypeScript,Python
source_url:
  html: https://developers.cloudflare.com/workers/examples/respond-with-another-site/
  md: https://developers.cloudflare.com/workers/examples/respond-with-another-site/index.md
---

If you want to get started quickly, click on the button below.

[![Deploy to Cloudflare](https://deploy.workers.cloudflare.com/button)](https://deploy.workers.cloudflare.com/?url=https://github.com/cloudflare/docs-examples/tree/main/workers/respond-with-another-site)

This creates a repository in your GitHub account and deploys the application to Cloudflare Workers.

* JavaScript

  ```js
  export default {
    async fetch(request) {
      function MethodNotAllowed(request) {
        return new Response(`Method ${request.method} not allowed.`, {
          status: 405,
          headers: {
            Allow: "GET",
          },
        });
      }
      // Only GET requests work with this proxy.
      if (request.method !== "GET") return MethodNotAllowed(request);
      return fetch(`https://example.com`);
    },
  };
  ```

  [Run Worker in Playground](https://workers.cloudflare.com/playground#LYVwNgLglgDghgJwgegGYHsHALQBM4RwDcABAEbogB2+CAngLzbPYZb6HbW5QDGU2AAwBmEQFYAbGJESJggFwsWbYBzhcafASPFSZcgLAAoAMLoqEAKYXsAESgBnGOgdRo5+SRV4CxElThgSwYAIigaSwAPADoAKwcQ0lQoMGtA4LCImPiQ4zMLawhsABU6GEtPOBgYMD4CKHNkWLgANzgHXgRYCABqYHRccEtjYyjnJBJcS1Q4cAgSAG8jEhJ2uipeL0sIXgALAAoESwBHEEsHCABKReWVr2pedyoSAFlt3YGAOXQIAEEwMDoADullwhxOZwu1yWdzuRwgIAQzyoliBJAASudnFQHJZ9gADN4QD64EgAEgWR1O5wg0SCxIGAF9-D9VgDgaDoviADQ3WGwi4EEAOTwAFkEYm5t35JF2ljgUwQIr5Mru-0BQM8IQA4gBRYohKWqkiMo38xmXIjSk3W5DIEgAeSoYDoJD1xRIVMhEAcJCBmAA1n63LsSMTHCQYAh0JE6NFrVBUCRwdSLnT3gMSABCBgMEg6-Uha7wxHPIkk75-dkgsFemmW60lpFbHYHfG7CAQGAiu1RQI1SzRXjoYD4hsrU1GRlEYxKZgqNQaHj8ISiYSSaTCWSCPLmKw2exOFxuBpUTzeNSkAJBUL0hW+RJeFJpG8hMiAsi5Ux7wolMoVVZqlqXh6kaeJzBGIwFhCYA4HCAB9fpBlSEJ5EyKZsgSRlZznBdfCXLRV10Tdt2YYwgA)

* TypeScript

  ```ts
  export default {
    async fetch(request): Promise<Response> {
      function MethodNotAllowed(request) {
        return new Response(`Method ${request.method} not allowed.`, {
          status: 405,
          headers: {
            Allow: "GET",
          },
        });
      }
      // Only GET requests work with this proxy.
      if (request.method !== "GET") return MethodNotAllowed(request);
      return fetch(`https://example.com`);
    },
  } satisfies ExportedHandler;
  ```

* Python

  ```py
  from workers import WorkerEntrypoint, Response, fetch


  class Default(WorkerEntrypoint):
      def fetch(self, request):
          def method_not_allowed(request):
              msg = f'Method {request.method} not allowed.'
              headers = {"Allow": "GET"}
              return Response(msg, headers=headers, status=405)


          # Only GET requests work with this proxy.
          if request.method != "GET":
              return method_not_allowed(request)


          return fetch("https://example.com")
  ```
