---
title: Reference Architectures · Cloudflare Reference Architecture docs
description: Reference architecture documents and diagrams are designed to
  provide a foundational knowledge of the Cloudflare platform and products.
  Building on the information in these documents, you can architect software
  solutions based on your specific context and needs.
lastUpdated: 2024-12-12T12:06:35.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/reference-architecture/architectures/
  md: https://developers.cloudflare.com/reference-architecture/architectures/index.md
---

Diagrams, design patterns and detailed best practices to help you generate solutions with Cloudflare products.

Reference architecture documents and diagrams are designed to provide a foundational knowledge of the Cloudflare platform and products. Building on the information in these documents, you can architect software solutions based on your specific context and needs.



* [Cloudflare Security Architecture](https://developers.cloudflare.com/reference-architecture/architectures/security/)
* [Content Delivery Network (CDN) Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/cdn/)
* [Enhancing security posture with SentinelOne and Cloudflare One](https://developers.cloudflare.com/reference-architecture/architectures/cloudflare-sase-with-sentinelone/)
* [Evolving to a SASE architecture with Cloudflare](https://developers.cloudflare.com/reference-architecture/architectures/sase/)
* [Load Balancing Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/load-balancing/)
* [Magic Transit Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/magic-transit/)
* [Multi-vendor Application Security and Performance Reference Architecture](https://developers.cloudflare.com/reference-architecture/architectures/multi-vendor/)
* [Reference Architecture using Cloudflare SASE with Microsoft](https://developers.cloudflare.com/reference-architecture/architectures/cloudflare-sase-with-microsoft/)
