---
title: Set up Private Network Load Balancing with Magic WAN · Cloudflare Load
  Balancing docs
description: Consider the following steps to learn how to configure Private
  Network Load Balancing solution, using Magic WAN as the on-ramp and off-ramp
  to securely connect to your private or internal services.
lastUpdated: 2025-08-19T09:22:14.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/load-balancing/private-network/magic-wan/
  md: https://developers.cloudflare.com/load-balancing/private-network/magic-wan/index.md
---

Consider the following steps to learn how to configure Private Network Load Balancing solution, using [Magic WAN](https://developers.cloudflare.com/magic-wan/) as the on-ramp and off-ramp to securely connect to your private or internal services.

One of the pre-requisites to using Private Network Load Balancing (PNLB) with Magic WAN is having Magic WAN set up in your account and having completed onboarding. You can connect with a Magic WAN Connector, or your own hardware via an IPsec or GRE tunnel. Check out the [Magic WAN documentation](https://developers.cloudflare.com/magic-wan/get-started/) for more details or to get started.

## 1. Create Load Balancer Pools

Load Balancer Pools are logical groupings of endpoints — typically organized by physical datacenter or geographic region. The endpoints in the pool are the destinations where traffic is ultimately routed.

Note

Endpoints accessed via Magic WAN must be accessible in and assigned to the default VNET.

Warning

The IP destination addresses must also be routable in your Magic WAN configuration. Please contact your Cloudflare account team to confirm that the addresses are available in your configuration.

Pools can be created using either the Cloudflare dashboard or the API. Refer to the [Create a pool](https://developers.cloudflare.com/load-balancing/pools/create-pool/#create-a-pool) documentation section for more information.

## 2. Create an Account Load Balancer with a Private IP

1. Go to **Load Balancing** at the account level and select **Create a Load Balancer**.
2. Select **Private Load Balancer**.
3. On the next step you can choose to associate this load balancer with either:

* A CGNAT IP from the Cloudflare range or
* A custom [RFC1918 address](https://datatracker.ietf.org/doc/html/rfc1918).

1. Add a descriptive name to identify your Load Balancer.
2. Proceed through the setup.

After selecting an IP address and completing the setup, you will be redirected to the Load Balancing dashboard. You can locate your load balancer using the search bar or by filtering for **Private** load balancers. Be sure to note the assigned IP address, as it will be required in the following steps.

Note

Traffic from your load balancer will appear to originate from one of Cloudflare’s IP addresses. These IP addresses must be whitelisted to ensure proper traffic flow. Ensure your routing is properly configured to return traffic to your Magic WAN tunnels and not the public Internet. Private Load Balancers created with a Cloudflare private IP address will receive an address in the CGNAT range `100.112.0.0`.

## 3. FQDN override (optional)

If you want your load balancer and its endpoints to be transparently accessible to users via a hostname, you can create a DNS record in your internal DNS system or create an override in Cloudflare that maps the hostname to the Load Balancer's IP address. This ensures that traffic destined for the hostname resolves to the correct IP.

To create the override, follow these steps:

1. In **Gateway**, select **Firewall policies**.

2. In the **DNS** tab, create an override where:

   * The **Selector** equals `Host`
   * The **Operator** equals `is`
   * The **Value** is the hostname you wish to associate with your load balancer.

3. Set the **Action** to *Override*, and in **Override Hostname**, enter the IP address of your Private Load Balancer.

Requests to the hostname will now resolve to your private load balancer.
