---
title: Browser Isolation Changelog · Cloudflare One docs
description: Review recent changes to Cloudflare Browser Isolation.
lastUpdated: 2025-07-07T17:31:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/changelog/browser-isolation/
  md: https://developers.cloudflare.com/cloudflare-one/changelog/browser-isolation/index.md
---

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/browser-isolation.xml)

## 2025-05-13

**SAML HTTP-POST bindings support for RBI**

Remote Browser Isolation (RBI) now supports SAML HTTP-POST bindings, enabling seamless authentication for SSO-enabled applications that rely on POST-based SAML responses from Identity Providers (IdPs) within a Remote Browser Isolation session. This update resolves a previous limitation that caused `405` errors during login and improves compatibility with multi-factor authentication (MFA) flows.

With expanded support for major IdPs like Okta and Azure AD, this enhancement delivers a more consistent and user-friendly experience across authentication workflows. Learn how to [set up Remote Browser Isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/).

## 2025-05-01

**Browser Isolation Overview page for Zero Trust**

A new **Browser Isolation Overview** page is now available in the Cloudflare Zero Trust dashboard. This centralized view simplifies the management of [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) deployments, providing:

* **Streamlined Onboarding:** Easily set up and manage isolation policies from one location.
* **Quick Testing:** Validate [clientless web application isolation](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/setup/clientless-browser-isolation/) with ease.
* **Simplified Configuration:** Configure [isolated access applications](https://developers.cloudflare.com/cloudflare-one/access-controls/policies/isolate-application/) and policies efficiently.
* **Centralized Monitoring:** Track aggregate usage and blocked actions.

This update consolidates previously disparate settings, accelerating deployment, improving visibility into isolation activity, and making it easier to ensure your protections are working effectively.

![Browser Isolation Overview](https://developers.cloudflare.com/_astro/browser-isolation-overview.Ljd5ax_O_PTyT8.webp)

To access the new overview, log in to your Cloudflare [Zero Trust dashboard](https://one.dash.cloudflare.com/) and find Browser Isolation in the side navigation bar.

## 2025-03-04

**Gain visibility into user actions in Zero Trust Browser Isolation sessions**

We're excited to announce that new logging capabilities for [Remote Browser Isolation (RBI)](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/) through [Logpush](https://developers.cloudflare.com/logs/logpush/logpush-job/datasets/account/) are available in Beta starting today!

With these enhanced logs, administrators can gain visibility into end user behavior in the remote browser and track blocked data extraction attempts, along with the websites that triggered them, in an isolated session.

```json
{
  "AccountID": "$ACCOUNT_ID",
  "Decision": "block",
  "DomainName": "www.example.com",
  "Timestamp": "2025-02-27T23:15:06Z",
  "Type": "copy",
  "UserID": "$USER_ID"
}
```

User Actions available:

* **Copy & Paste**
* **Downloads & Uploads**
* **Printing**

Learn more about how to get started with Logpush in our [documentation](https://developers.cloudflare.com/logs/logpush/).

## 2024-11-21

**Improved non-English keyboard support**

You can now type in languages that use diacritics (like á or ç) and character-based scripts (such as Chinese, Japanese, and Korean) directly within the remote browser. The isolated browser now properly recognizes non-English keyboard input, eliminating the need to copy and paste content from a local browser or device.

## 2024-03-21

**Removed third-party cookie dependencies**

Removed dependency on third-party cookies in the isolated browser, fixing an issue that previously caused intermittent disruptions for users maintaining multi-site, cross-tab sessions in the isolated browser.
